import { createReadStream } from 'fs';
import { parse } from 'csv-parse';
import sql from 'mssql';
import { config } from './config.js';

const readCustomerCSV = async (filename) => {
  const customers = [];
  return new Promise((resolve, reject) => {
    createReadStream(filename)
      .pipe(parse({ columns: true, trim: true }))
      .on('data', (data) => customers.push(data))
      .on('end', () => resolve(customers))
      .on('error', (error) => reject(error));
  });
};

const insertCustomers = async (filename) => {
  try {
    // read customer data from a CSV file
    const customers = await readCustomerCSV(filename);

    // Connect to the SQL Server
    await sql.connect(config);

    // Initialize a Table object
    const table = new sql.Table('Customers');

    // Set to false because the table already exists.
    // If the table does not exist, set to true , it will create the table
    table.create = false;

    table.columns.add('FirstName', sql.VarChar(100), { nullable: false });
    table.columns.add('LastName', sql.VarChar(100), { nullable: false });
    table.columns.add('Email', sql.VarChar(255), { nullable: false });
    table.columns.add('PhoneNumber', sql.VarChar(20), { nullable: false });
    table.columns.add('Address', sql.VarChar(255), { nullable: false });

    // Add rows to the table
    // Add rows to the table
    customers.forEach((c) => {
      table.rows.add(
        c.FirstName,
        c.LastName,
        c.Email,
        c.PhoneNumber,
        c.Address
      );
    });

    // Create a new bulk request to the Customers table
    const request = new sql.Request();

    // Execute the bulk insert
    request.bulk(table);
  } catch (err) {
    console.error(err);
  }
};

export { insertCustomers };
